/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.ninni.etcetera.client.model.TurtleRaftModel;
import com.ninni.etcetera.client.renderer.entity.layer.TurtleRaftBannerLayer;
import com.ninni.etcetera.client.renderer.entity.layer.TurtleRaftColorRenderLayer;
import com.ninni.etcetera.entity.TurtleRaftEntity;
import com.ninni.etcetera.registry.EtceteraEntityModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class TurtleRaftRenderer
extends EntityRenderer<TurtleRaftEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("etcetera", "textures/entity/boat/turtle_raft_overlay.png");
    private final TurtleRaftModel model;
    private final TurtleRaftColorRenderLayer layer;
    private final TurtleRaftBannerLayer bannerLayer;

    public TurtleRaftRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = this.createModel(ctx);
        this.layer = this.createLayer(ctx);
        this.bannerLayer = this.createBannerLayer();
    }

    private TurtleRaftModel createModel(EntityRendererProvider.Context ctx) {
        return new TurtleRaftModel(ctx.m_174023_(EtceteraEntityModelLayers.TURTLE_RAFT));
    }

    private TurtleRaftColorRenderLayer createLayer(EntityRendererProvider.Context ctx) {
        return new TurtleRaftColorRenderLayer(new RenderLayerParent<TurtleRaftEntity, TurtleRaftModel>(){

            public TurtleRaftModel getModel() {
                return TurtleRaftRenderer.this.model;
            }

            public ResourceLocation getTextureLocation(TurtleRaftEntity entity) {
                return TEXTURE;
            }
        }, ctx.m_174027_());
    }

    private TurtleRaftBannerLayer createBannerLayer() {
        return new TurtleRaftBannerLayer(new RenderLayerParent<TurtleRaftEntity, TurtleRaftModel>(){

            public TurtleRaftModel getModel() {
                return TurtleRaftRenderer.this.model;
            }

            public ResourceLocation getTextureLocation(TurtleRaftEntity entity) {
                return TEXTURE;
            }
        });
    }

    public void render(TurtleRaftEntity raft, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.375, 0.0);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - f));
        float h = (float)raft.m_38385_() - g;
        float j = raft.m_38384_() - g;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)h) * h * j / 10.0f * (float)raft.m_38386_()));
        }
        if (!Mth.m_14033_((float)raft.m_38352_(g), (float)0.0f)) {
            matrixStack.m_252781_(new Quaternionf().setAngleAxis(raft.m_38352_(g) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        this.model.setupAnim(raft, g, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(this.model.m_103119_(TEXTURE));
        this.model.m_7695_(matrixStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.layer.render(matrixStack, vertexConsumerProvider, i, raft, 1.0f, 1.0f, g, 1.0f, 1.0f, 1.0f);
        this.bannerLayer.render(matrixStack, vertexConsumerProvider, i, raft, 1.0f, 1.0f, g, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        super.m_7392_((Entity)raft, f, g, matrixStack, vertexConsumerProvider, i);
    }

    public ResourceLocation getTextureLocation(TurtleRaftEntity entity) {
        return TEXTURE;
    }
}

